<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {

            $table->id();
            $table->string('name', 100);
            $table->string('avatar', 100)->nullable();
            $table->string('phone', 75)->nullable();
            $table->text('bio')->nullable();
            $table->enum('status', [1, 0])->default(1)->comment("If the account is banned, the value will be 0");
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('last_activity')->nullable()->index();
            $table->string('password', 150);
            $table->unsignedBigInteger('fav_language')->nullable();
            $table->foreign('fav_language')->references("id")->on('languages')->onDelete('set null')->onUpdate('cascade');
            $table->string('color_scheme')->default('light');
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
